//--------------------------------------------------------------------------//
//----Dr.Jummybummy's Space Adventure 2 Fighting Engine---------------------//
//--------------------------------------------------------------------------//

(include "sci.sh")
(include "game.sh")
(script 133)
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
pLives    //Variable that contains the player lives
enLives   //Enemy lives variable
block     //If TRUE, then player is blocking hits
eBlock    //If TRUE then enemy is blocking
loseLife  //When enemy gets hit, enemy lives lower by the amount of this variable
loseLife2 //When player gets hit, lives lower by the amount of this variable
var1      //)
var2      //)Two variables used in EnemyAction procedure
)
(instance public rm133 of Rm
	(properties
		picture 143
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
        (aLight: init())
      ProgramControl()
        = gTimeSeconds2 0
Format(@enLives "%d" enemyLives)
Display(@enLives dsCOORD 38 1 dsCOLOR 10 dsBACKGROUND 0)
Format(@pLives "%d" PlayerLives)
Display(@pLives dsCOORD 238 1 dsCOLOR 10 dsBACKGROUND 0)
		(self:setScript(RoomScript))
        (aPlayer: init())
        (aEnemy: init())
Print("INSERT - Face Kick   \nDELETE - Punch     \nENTER - Block (5 sec)     "
#title "You've got to fight!" #dispose #time 9 #at 80 150)

	)
)
/******************************************************************************/
(instance PlayerLivesLose of Script
	(properties)
(method(changeState newState)
= newState 0
= state newState
(switch(state)
(case 0
EnemyStill()
(if(block)
return
)
= loseLife2 Random(1 4)
(if(>= loseLife2 3)
= loseLife2 1
)
(if(< PlayerLives loseLife2)
= PlayerLives 0
return
)
-= PlayerLives loseLife2
return
)
)
)
)


(instance EnemyLives of Script
	(properties)
(method(changeState newState)
= newState 0
= state newState
(switch(state)
(case 0
EnemyAction() //Now our enemy checks, does he want to block, or hit too
(if(not(eBlock))
= loseLife Random(1 3)
(if(== loseLife 3)
= loseLife 1
)
(if(< enemyLives loseLife)
= enemyLives 0
PlayerStill()
return
)
-= enemyLives loseLife
PlayerStill()
return
)
)
)
)

)
(instance RoomScript of Script
	(properties)
(method(doit)
(var dyingScript)
Format(@pLives "%d  " PlayerLives)
Display(@pLives dsCOORD 238 1 dsCOLOR 10 dsBACKGROUND 0)
Display("Press F4 to skip fight" dsCOORD 80 1 dsCOLOR 14 dsBACKGROUND 0)
Format(@enLives "%d  " enemyLives)
Display(@enLives dsCOORD 38 1 dsCOLOR 10 dsBACKGROUND 0)
(if(== PlayerLives 0)
= dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("Looks like you're not going to be the next Mike Tyson. You lost!")
  )
  (send gGame:setScript(dyingScript))

)
(if(== enemyLives 0)    //This part is executed when you win the match!
Print("You knocked the guard out.")
Print("After searching him, you find a piece of paper ...")
Print("... which tells the location of the troops on Earth!!!" #font 7)
PlayerControl()
(send gRoom: newRoom(143))
)
(if(>= sec3 4)
= block FALSE
)
(if(>= gTimeSeconds2 2)
(if(not(block))
EnemyAction()
= gTimeSeconds2 0
)
)
(if(eBlock)
(aEnemy: loop(2) cel(0))
)
(if(== sec2 2)  //enemy block time
(if(eBlock)
= eBlock FALSE
= sec2 3
EnemyAction()
)
)

(if(== sec3 3)  //This is the player block time. He blocks for 3 seconds, then you have to block again if you want
(if(block)
= block FALSE
= sec3 4
PlayerStill()
EnemyAction()
)
)
(if(== enemyLives 0)
= guard1Down TRUE

)
)
(method (handleEvent pEvent)
(super:handleEvent(pEvent))
(if( not (send pEvent:claimed) )
(if(==(send pEvent:type) evKEYBOARD)
(if(==(send pEvent:message) KEY_INSERT)  //Player hits the enemy's face
= block FALSE
(aPlayer: loop(0) setCycle(End EnemyLives))
)
(if(== (send pEvent:message) KEY_DELETE) //Player hits enemy's stomach
= block FALSE
(aPlayer: loop(1) setCycle(End EnemyLives))
)
(if(== (send pEvent:message) KEY_RETURN) //Player blocks
= block TRUE
= sec3 0
(aPlayer: loop(2) cel(0))
)
)
)
)

)

(instance aPlayer of Act
(properties
view 164
x 152
y 120
))
(instance aEnemy of Act
(properties
view 165
x 142
y 120
))
 (instance aLight of Prop
(properties
view 205
x 84
y 34
cel 0
))
(procedure public (PlayerStill) //Makes the player stand still
(aPlayer: loop(0) cel(0))
)
(procedure public (EnemyStill) //Makes the enemy stand still
(aEnemy: loop(0) cel(0))
)
(procedure public (EnemyAction) //This prcedure checks if enemy wants to block or fight. The actions are random.
(if(not(guard1Down))//This global variable is set to TRUE when enemyLives == 00
Wait(1)
= var1 Random(1 3) //If 1 then blocks, if higher or equal to 2 ,then randoms the hit: face or stomach.
(if(== var1 1)
= eBlock TRUE
= sec2 0
(aEnemy: loop(2) cel(0))
return
)
(if(>= var1 2)
= var2 Random(1 2)
(if(== var2 1) //Hits the face
= eBlock FALSE
(aEnemy: loop(0) cel(0) setCycle(End PlayerLivesLose))
)
(if(== var2 2) //Hits the stomach
= eBlock FALSE
(aEnemy: loop(1) cel(0) setCycle(End PlayerLivesLose))
)
return
)
)
)//end procedure

/******************************************************************************/
